<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "commands".
 *
 * @property int $id
 * @property string $created_at
 * @property int $bot_id
 * @property string $command
 * @property int $status
 * @property int $admin
 * @property int $commandtype
 * @property string $result
 */
class BotCommands extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'commands';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['created_at'], 'safe'],
            [['bot_id'], 'required'],
            [['bot_id', 'status', 'admin', 'commandtype'], 'default', 'value' => null],
            [['bot_id', 'status', 'admin', 'commandtype'], 'integer'],
            [['command', 'result', 'usercommand'], 'string'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'created_at' => 'Created At',
            'bot_id' => 'Bot ID',
            'command' => 'Command',
            'status' => 'Status',
            'admin' => 'Admin',
            'commandtype' => 'Commandtype',
            'result' => 'Result',
            'usercommand' => 'Command',
        ];
    }
}
